//	Unit to simplify semaphore access in Critical Mass

#include "CMSemaphore.h"					//	the header

#define SEM_ERR_MSG SUICIDE_NOTE"Lost track of my fingers:\n\n"
#define ACQUIRE_FAILED SEM_ERR_MSG"acquire_sem() failed:\n"
#define CREATE_FAILED SEM_ERR_MSG"create_sem() failed:\n"
#define DELETE_FAILED SEM_ERR_MSG"delete_sem() failed:\n"
#define RELEASE_FAILED SEM_ERR_MSG"release_sem() failed:\n"
#define WAS_BAD_COUNT "system reported bad thread count"
#define WAS_NO_MEMORY "system reported no memory for semaphore name"
#define WAS_NO_MORE_SEMS "system reported no semaphore IDs available"
#define WAS_BAD_SEM_ID "system reported a bad semaphore ID:\nEither it didn't exist, or it was someone else's"

CMSemaphore::CMSemaphore(char *name, uint32 count)
									//	constructor
	{
	theSemaphore = create_sem(count, name);	//	call system to create semaphore
	if (theSemaphore == B_BAD_VALUE)		//	deal with errors one at a time
		cMass->FatalErrorAlert(CREATE_FAILED WAS_BAD_COUNT);
	else if (theSemaphore == B_NO_MEMORY)	//	out of memory
		cMass->FatalErrorAlert(CREATE_FAILED WAS_NO_MEMORY);
	else if (theSemaphore == B_NO_MORE_SEMS)//	system semaphores exhausted
		cMass->FatalErrorAlert(CREATE_FAILED WAS_NO_MORE_SEMS);
	} // end of constructor

CMSemaphore::~CMSemaphore()				//	destructor
	{
	status_t errorCode;					//	for catching return values
	
	errorCode = delete_sem(theSemaphore);	//	delete the semaphore
	if (errorCode == B_BAD_SEM_ID)		//	if it was a bad ID
		cMass->FatalErrorAlert(DELETE_FAILED WAS_BAD_SEM_ID);
	}	

void CMSemaphore::Acquire()				//	acquire the semaphore
	{
	status_t errorCode;					//	for catching return values
	
	errorCode = acquire_sem(theSemaphore);	//	acquire the semaphore
	if (errorCode == B_BAD_SEM_ID)		//	if it was a bad ID
		cMass->FatalErrorAlert(ACQUIRE_FAILED WAS_BAD_SEM_ID);
	} // end of Acquire()
	
void CMSemaphore::Release()				//	release the semaphore
	{
	status_t errorCode;					//	for catching return values
	
	errorCode = release_sem(theSemaphore);	//	release the semaphore
	if (errorCode == B_BAD_SEM_ID)		//	if it was a bad ID
		cMass->FatalErrorAlert(RELEASE_FAILED WAS_BAD_SEM_ID);
	} // end of Release()
	